/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.report.urgentpath.GorWaitingComputerResult;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GarWaitingComputer {
    private Box lastBox;

    @Nonnull
    public static GorWaitingComputerResult getWaitingIntervals(@Nullable List<GeneralizedActionRequest> gars) {
        if (gars == null || gars.isEmpty() || gars.size() == 1 && gars.get(0).getActivities().size() == 1) {
            return GorWaitingComputerResult.EMPTY;
        }
        BoxesBuilder builder = new BoxesBuilder(gars);
        Tuple<List<Box>, List<Connection>> boxesConnections = builder.createBoxesConnections();
        GarWaitingComputer computer = new GarWaitingComputer(boxesConnections.getFirst());
        Map<Box, List<Tuple<TimeSpan, Boolean>>> result = computer.compute();
        HashMap<GeneralizedActionRequest, GorWaitingComputerResult.GarWaitingInfo> waitings = Maps.newHashMap();
        for (Box box : boxesConnections.getFirst()) {
            GeneralizedActionRequest gar = box.relatedAa.getGar();
            List<Tuple<TimeSpan, Boolean>> tss = result.get(box);
            ArrayList<GorWaitingComputerResult.WaitingPiece> wps = null;
            if (tss != null) {
                wps = Lists.newArrayList(Collections2.transform(tss, new Function<Tuple<TimeSpan, Boolean>, GorWaitingComputerResult.WaitingPiece>(){

                    @Override
                    @Nullable
                    public GorWaitingComputerResult.WaitingPiece apply(@Nullable Tuple<TimeSpan, Boolean> input) {
                        return new GorWaitingComputerResult.WaitingPiece(input.getFirst(), input.getSecond());
                    }
                }));
            }
            long minTime = 0L;
            for (Connection con : box.connections) {
                if (con.length != con.minLength || con.type != Connection.Type.LEFT_BOUND && con.type != Connection.Type.RIGHT_BOUND) continue;
                minTime = Math.max(minTime, con.minLength);
            }
            GorWaitingComputerResult.GarWaitingInfo waiting = (GorWaitingComputerResult.GarWaitingInfo)waitings.get(gar);
            if (waiting == null) {
                waiting = new GorWaitingComputerResult.GarWaitingInfo(gar, wps == null ? Lists.newArrayList() : wps, minTime);
                waitings.put(gar, waiting);
                continue;
            }
            if (wps != null) {
                waiting.waitings.addAll(wps);
            }
            waiting.minimumTimeBefore = Math.max(waiting.minimumTimeBefore, minTime);
        }
        return new GorWaitingComputerResult(waitings);
    }

    private GarWaitingComputer(List<Box> gars) {
        for (Box gar : gars) {
            if (this.lastBox == null) {
                this.lastBox = gar;
                continue;
            }
            if (this.lastBox.place >= gar.place && (this.lastBox.place != gar.place || this.lastBox.order >= gar.order)) continue;
            this.lastBox = gar;
        }
    }

    private Map<Box, List<Tuple<TimeSpan, Boolean>>> compute() {
        HashMap<Box, List<Tuple<TimeSpan, Boolean>>> waitings = Maps.newHashMap();
        Tuple<Set<Box>, List<Connection>> boxesConnections = this.findMovedBoxesAndConnections();
        while (!boxesConnections.getSecond().isEmpty()) {
            List<Connection> activeConnections;
            Set<Box> movedBoxes = boxesConnections.getFirst();
            Tuple<Box, TimeSpan> waiting = this.move(movedBoxes, activeConnections = boxesConnections.getSecond());
            if (waitings.containsKey(waiting.getFirst())) {
                ((List)waitings.get(waiting.getFirst())).add(Tuple.create(waiting.getSecond(), waiting.getFirst().order > 0));
            } else {
                waitings.put(waiting.getFirst(), Lists.newArrayList(Tuple.create(waiting.getSecond(), waiting.getFirst().order > 0)));
            }
            boxesConnections = this.findMovedBoxesAndConnections();
        }
        return waitings;
    }

    private Tuple<Box, TimeSpan> move(Set<Box> movedBoxes, List<Connection> activeConnections) {
        long length = Long.MAX_VALUE;
        for (Connection activeConnection : activeConnections) {
            if (length <= activeConnection.length) continue;
            length = activeConnection.length - activeConnection.minLength;
        }
        for (Connection connection : activeConnections) {
            connection.length -= length;
        }
        Box waitingBox = null;
        for (Box box : movedBoxes) {
            box.moveLeft(length);
            if (waitingBox == null) {
                waitingBox = box;
                continue;
            }
            if (waitingBox.place <= box.place && (waitingBox.place != box.place || waitingBox.order <= box.order)) continue;
            waitingBox = box;
        }
        return Tuple.create(waitingBox, TimeSpan.fromStartEnd(waitingBox.start, waitingBox.start + length));
    }

    private Tuple<Set<Box>, List<Connection>> findMovedBoxesAndConnections() {
        ArrayList<Connection> activeConnections = Lists.newArrayList();
        HashSet<Box> movedBoxes = Sets.newHashSet();
        LinkedList<Box> open = Lists.newLinkedList();
        open.add(this.lastBox);
        while (!open.isEmpty()) {
            Box box = (Box)open.removeLast();
            if (!movedBoxes.add(box)) continue;
            for (Connection connection : box.connections) {
                if (connection.length == connection.minLength) {
                    open.add(connection.to);
                    continue;
                }
                activeConnections.add(connection);
            }
        }
        ListIterator it = activeConnections.listIterator();
        while (it.hasNext()) {
            Connection conn = (Connection)it.next();
            if (!movedBoxes.contains(conn.from) || !movedBoxes.contains(conn.to)) continue;
            it.remove();
        }
        return Tuple.create(movedBoxes, activeConnections);
    }

    private static class BoxesBuilder {
        private List<GeneralizedActionRequest> gars;

        private BoxesBuilder(List<GeneralizedActionRequest> gars) {
            this.gars = gars;
        }

        private Tuple<List<Box>, List<Connection>> createBoxesConnections() {
            ArrayList<Box> boxes = Lists.newArrayList();
            int rail = 0;
            GeneralizedActionRequest predGar = null;
            for (GeneralizedActionRequest gar : this.gars) {
                int order = 0;
                long lib = BoxesBuilder.getLeftInputBound(gar);
                long rib = BoxesBuilder.getRightInputBound(gar, predGar);
                long lob = BoxesBuilder.getLeftOutputBound(gar);
                long rob = BoxesBuilder.getRightOutputBound(gar);
                long prevAaTime = 0L;
                for (ActionActivity aa : gar.getActivities()) {
                    Long leftInputBound = prevAaTime <= lib && lib < prevAaTime + aa.getDuration() ? Long.valueOf(lib - prevAaTime) : null;
                    Long rightInputBound = prevAaTime <= rib && rib < prevAaTime + aa.getDuration() || gar.getActivities().size() == order + 1 ? Long.valueOf(rib - prevAaTime) : null;
                    Long leftOutputBound = prevAaTime < lob && lob <= prevAaTime + aa.getDuration() ? Long.valueOf(lob - prevAaTime) : (prevAaTime == 0L && lob == 0L ? Long.valueOf(0L) : null);
                    Long rightOutputBound = prevAaTime < rob && rob <= prevAaTime + aa.getDuration() ? Long.valueOf(rob - prevAaTime) : null;
                    Box box = new Box(aa, rail, order, aa.getStart(), aa.getEnd(), leftInputBound, rightInputBound, leftOutputBound, rightOutputBound);
                    boxes.add(box);
                    ++order;
                    prevAaTime += aa.getDuration();
                }
                predGar = gar;
                ++rail;
            }
            List<Connection> connections = BoxesBuilder.createConnections(boxes);
            return Tuple.create(boxes, connections);
        }

        private static List<Connection> createConnections(List<Box> boxes) {
            Connection connection;
            HashMap<Integer, ArrayList<Box>> boxesByRails = Maps.newHashMap();
            ArrayList<Integer> rails = Lists.newArrayList();
            for (Box box : boxes) {
                if (boxesByRails.containsKey(box.place)) {
                    ((List)boxesByRails.get(box.place)).add(box);
                    continue;
                }
                boxesByRails.put(box.place, Lists.newArrayList(box));
                rails.add(box.place);
            }
            Collections.sort(rails);
            for (Object bs : boxesByRails.values()) {
                Collections.sort(bs, new Comparator<Box>(){

                    @Override
                    public int compare(Box o1, Box o2) {
                        return Integer.compare(o1.order, o2.order);
                    }
                });
            }
            ArrayList<Connection> connections = Lists.newArrayList();
            for (List bs : boxesByRails.values()) {
                for (int i = 0; i < bs.size() - 1; ++i) {
                    Box first = (Box)bs.get(i);
                    Box second = (Box)bs.get(i + 1);
                    connection = new Connection(second, first, second.start - first.end, 0L, Connection.Type.BOX);
                    connections.add(connection);
                    second.connections.add(connection);
                }
            }
            for (int i = 0; i < rails.size() - 1; ++i) {
                int rail = (Integer)rails.get(i);
                int nextRail = (Integer)rails.get(i + 1);
                Box leftOutputBoundBox = BoxesBuilder.getLeftOutputBoundBox((List)boxesByRails.get(rail));
                Box leftInputBoundBox = BoxesBuilder.getLeftInputBoundBox((List)boxesByRails.get(nextRail));
                connection = new Connection(leftInputBoundBox, leftOutputBoundBox, leftInputBoundBox.getLeftInputBoundTime() - leftOutputBoundBox.getLeftOutputBoundTime(), leftInputBoundBox.relatedAa.getAction().getMinTimeToPrepare(), Connection.Type.LEFT_BOUND);
                connections.add(connection);
                leftInputBoundBox.connections.add(connection);
                Box rightOutputBoundBox = BoxesBuilder.getRightOutputBoundBox((List)boxesByRails.get(rail));
                Box rightInputBoundBox = BoxesBuilder.getRightInputBoundBox((List)boxesByRails.get(nextRail));
                connection = new Connection(rightInputBoundBox, rightOutputBoundBox, rightInputBoundBox.getRightInputBoundTime() - rightOutputBoundBox.getRightOutputBoundTime(), rightInputBoundBox.relatedAa.getAction().getMinTimeToPrepare(), Connection.Type.RIGHT_BOUND);
                connections.add(connection);
                rightInputBoundBox.connections.add(connection);
            }
            return connections;
        }

        private static long getLeftInputBound(@Nonnull GeneralizedActionRequest gar) {
            return 0L;
        }

        private static long getRightInputBound(@Nonnull GeneralizedActionRequest gar, @Nullable GeneralizedActionRequest predGar) {
            if (predGar == null || predGar.getInPlanQty() < predGar.getAction().getTransferBatch() || predGar.getAction().getTransferBatch() < 0.0) {
                return 0L;
            }
            if (predGar.getAction().getTransferBatch() == 0.0) {
                return gar.getPlannedDuration();
            }
            return Math.max(gar.getPlannedDuration() - gar.getAction().timeToMake(predGar.getAction().getTransferBatch()), 0L);
        }

        private static long getLeftOutputBound(@Nonnull GeneralizedActionRequest gar) {
            if (gar.getInPlanQty() < gar.getAction().getTransferBatch() || gar.getAction().getTransferBatch() < 0.0) {
                return gar.getPlannedDuration();
            }
            if (gar.getAction().getTransferBatch() == 0.0) {
                return 0L;
            }
            return Math.min(gar.getAction().getTransferBatchTime(), gar.getPlannedDuration());
        }

        private static long getRightOutputBound(@Nonnull GeneralizedActionRequest gar) {
            return gar.getPlannedDuration();
        }

        @Nonnull
        private static Box getLeftOutputBoundBox(List<Box> boxes) {
            Box box = Collections3.search(boxes, new Predicate<Box>(){

                @Override
                public boolean apply(@Nullable Box input) {
                    return input.hasLeftOutputBound();
                }
            });
            Preconditions.checkState(box != null);
            return box;
        }

        @Nonnull
        private static Box getLeftInputBoundBox(List<Box> boxes) {
            Box box = Collections3.search(boxes, new Predicate<Box>(){

                @Override
                public boolean apply(@Nullable Box input) {
                    return input.hasLeftInputBound();
                }
            });
            Preconditions.checkState(box != null);
            return box;
        }

        @Nonnull
        private static Box getRightOutputBoundBox(List<Box> boxes) {
            Box box = Collections3.search(boxes, new Predicate<Box>(){

                @Override
                public boolean apply(@Nullable Box input) {
                    return input.hasRightOutputBound();
                }
            });
            Preconditions.checkState(box != null);
            return box;
        }

        @Nonnull
        private static Box getRightInputBoundBox(List<Box> boxes) {
            Box box = Collections3.search(boxes, new Predicate<Box>(){

                @Override
                public boolean apply(@Nullable Box input) {
                    return input.hasRightInputBound();
                }
            });
            Preconditions.checkState(box != null);
            return box;
        }
    }

    private static class Box {
        private ActionActivity relatedAa;
        private int place;
        private int order;
        private long start;
        private long end;
        private Long leftInputBound;
        private Long rightInputBound;
        private Long leftOutputBound;
        private Long rightOutputBound;
        private List<Connection> connections = Lists.newArrayList();

        private Box() {
        }

        private Box(ActionActivity relatedAa, int place, int order, long start, long end, Long leftInputBound, Long rightInputBound, Long leftOutputBound, Long rightOutputBound) {
            this();
            this.relatedAa = relatedAa;
            this.place = place;
            this.order = order;
            this.start = start;
            this.end = end;
            this.leftInputBound = leftInputBound;
            this.rightInputBound = rightInputBound;
            this.leftOutputBound = leftOutputBound;
            this.rightOutputBound = rightOutputBound;
        }

        private void moveLeft(long amount) {
            this.start -= Math.abs(amount);
            this.end -= Math.abs(amount);
        }

        private boolean hasLeftInputBound() {
            return this.leftInputBound != null;
        }

        private boolean hasRightInputBound() {
            return this.rightInputBound != null;
        }

        private boolean hasLeftOutputBound() {
            return this.leftOutputBound != null;
        }

        private boolean hasRightOutputBound() {
            return this.rightOutputBound != null;
        }

        public Long getLeftInputBoundTime() {
            return this.leftInputBound + this.start;
        }

        public Long getRightInputBoundTime() {
            return this.rightInputBound + this.start;
        }

        public Long getLeftOutputBoundTime() {
            return this.leftOutputBound + this.start;
        }

        public Long getRightOutputBoundTime() {
            return this.rightOutputBound + this.start;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Box)) {
                return false;
            }
            Box box = (Box)o;
            return this.place == box.place && this.order == box.order && Objects.equals(this.relatedAa, box.relatedAa) && Objects.equals(this.leftInputBound, box.leftInputBound) && Objects.equals(this.rightInputBound, box.rightInputBound) && Objects.equals(this.leftOutputBound, box.leftOutputBound) && Objects.equals(this.rightOutputBound, box.rightOutputBound);
        }

        public int hashCode() {
            int result = this.relatedAa.hashCode();
            result = 31 * result + this.place;
            result = 31 * result + this.order;
            result = 31 * result + (this.leftInputBound != null ? this.leftInputBound.hashCode() : 0);
            result = 31 * result + (this.rightInputBound != null ? this.rightInputBound.hashCode() : 0);
            result = 31 * result + (this.leftOutputBound != null ? this.leftOutputBound.hashCode() : 0);
            result = 31 * result + (this.rightOutputBound != null ? this.rightOutputBound.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Box{place=" + this.place + ", order=" + this.order + ", start=" + this.start + ", end=" + this.end + ", leftInputBound=" + this.leftInputBound + ", rightInputBound=" + this.rightInputBound + ", leftOutputBound=" + this.leftOutputBound + ", rightOutputBound=" + this.rightOutputBound + "}";
        }
    }

    private static class Connection {
        private Box from;
        private Box to;
        private long length;
        private long minLength;
        private Type type;

        private Connection(Box from, Box to, long length, long minLength, Type type) {
            if (length < 0L) {
                length = 0L;
            }
            this.from = from;
            this.to = to;
            this.length = length;
            this.minLength = Math.min(minLength, length);
            this.type = type;
        }

        public String toString() {
            return "Connection{length=" + this.length + ", minLength=" + this.minLength + ", from=" + this.from + ", to=" + this.to + ", type=" + this.type + "}";
        }

        private static enum Type {
            LEFT_BOUND,
            RIGHT_BOUND,
            BOX;

        }
    }
}

